# War aims: Over what are actors claiming to fight? 
# (Difficult to say, because leaders may have different *motivations* than rank-and-file soldiers. However,
# this is not about *motives*, but about the overall aim, claimed by the warring parties)
#
# EPRv1&2 datasets only contain values up to 2005
# EPRv3 (http://www.epr.ucla.edu/): unclear coding and variable description; no codebook available!
#   - there is a "actoraim" variable with unclear coding
#   - EAC contains coding for ethnic wars and secessionist wars
#     * not available in country-year format (only country-warperiod) -> I transformed it manually
#   - ethfrac (fractionalization?) is only available per country, but not per year! There is no variation.
# PITF:
#   - ethnic wars (seek changes for ethnic grousp)
#   - revolutionary wars (seek changes of government)
#   - genocidal wars (extermination of groups); two codings
#     * is it a genocidal war?
#     * how many deaths (DEATHMAG)?
# UCDP:
#   - incompatiblity: Government vs. Territory

##
## SVAC / UCDP (recode incompatibility dummy: Government = 1; Territory = 0)
##
Master$incomp_dummy <- Master$incomp - 1
#Master[Master$incomp==2]$incomp_dummy <- 1

##
## Ethic Power Relations Dataset (ethnic & secessionist conflict)
##
epr <- read.csv("Daten/EPRv3/EPR3_1989-2009.csv", sep=";", as.is=T)

# delete duplicates
epr <- epr[!duplicated(epr),]
epr <- aggregate(epr$Secessionist.conflict, by = list(epr$cowcode, epr$year, epr$Ethnic.conflict), max, na.rm=T)
epr <- aggregate(epr$Group.3, by = list(epr$Group.1, epr$Group.2, epr$x), max, na.rm=T)
epr <- rename(epr, c("Group.1" = "actorid", "Group.2" = "year", "x" = "epr_ethwar", "Group.3" = "epr_secesswar"))


##
## Political Instability Task Force Dataset (ethnic, revolutionary & genocidal war)
##
pitf_ethnic <- read.xls("Daten/PITF Political Instability Task Force/PITF Ethnic War 2013.xls")
pitf_ethnic$pitf_ethwar <- 1
pitf_ethnic <- subset(pitf_ethnic, 
                      subset = pitf_ethnic$YEAR > 1988 & pitf_ethnic$YEAR < 2010, 
                      select = c(CCODE, YEAR, pitf_ethwar))
pitf_ethnic <- rename(pitf_ethnic, c("CCODE"="actorid", "YEAR"="year"))
pitf_ethnic <- pitf_ethnic[!duplicated(pitf_ethnic),]

pitf_rev <- read.xls("Daten/PITF Political Instability Task Force/PITF Revolutionary War 2013.xls")
pitf_rev$pitf_revwar <- 1
pitf_rev <- subset(pitf_rev, subset = pitf_rev$YEAR > 1988 & pitf_rev$YEAR < 2010, select = c(CCODE, YEAR, pitf_revwar))
pitf_rev <- rename(pitf_rev, c("CCODE"="actorid", "YEAR"="year"))
pitf_rev <- pitf_rev[!duplicated(pitf_rev),]

pitf_genocide <- read.xls("Daten/PITF Political Instability Task Force/PITF GenoPoliticide 2013.xls")
pitf_genocide$pitf_genocwar <- 1
pitf_genocide <- subset(pitf_genocide, 
                        subset = pitf_genocide$YEAR > 1988 & pitf_genocide$YEAR < 2010, 
                        select = c(CCODE, YEAR, pitf_genocwar, DEATHMAG))
pitf_genocide <- rename(pitf_genocide, c("CCODE"="actorid", "YEAR"="year", "DEATHMAG" = "pitf_genocwar_deathmag"))
pitf_genocide <- pitf_genocide[!duplicated(pitf_genocide),]

##
## Join all to main dataset
## 

Master <- join(Master, epr, type = "left", match = "all", by = c("actorid", "year"))
Master <- join(Master, pitf_ethnic, type = "left", match = "all", by = c("actorid", "year"))
Master <- join(Master, pitf_rev, type = "left", match = "all", by = c("actorid", "year"))
Master <- join(Master, pitf_genocide, type = "left", match = "all", by = c("actorid", "year"))

rm(epr, pitf_ethnic, pitf_rev, pitf_genocide)

# Fill all other cases with Zero (no such war) instead of NA
Master$epr_ethwar[is.na(Master$epr_ethwar)] <- 0
Master$epr_secesswar[is.na(Master$epr_secesswar)] <- 0
Master$pitf_ethwar[is.na(Master$pitf_ethwar)] <- 0
Master$pitf_revwar[is.na(Master$pitf_revwar)] <- 0
Master$pitf_genocwar[is.na(Master$pitf_genocwar)] <- 0
Master$pitf_genocwar_deathmag[is.na(Master$pitf_genocwar_deathmag)] <- 0

##
## some correlations
##

# cor(Master$pitf_ethwar, Master$epr_ethwar, use="pair", method="spearman") # .790
# cor(Master$pitf_ethwar, Master$pitf_genocwar, use="pair", method="spearman") # .230
# cor(Master$pitf_ethwar, Master$epr_secesswar, use="pair", method="spearman") # .746
# cor(Master$epr_secesswar, Master$incomp_dummy, use="pair", method="spearman") # -.087 (negativ sollte es sein, da 0=Territory; aber nur so niedrig korreliert? sollte es nicht ähnliche Konstrukte messen?)
